package gov.va.med.mhv.rxrefill.data.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import gov.va.med.mhv.rxrefill.data.model.UserEmailNotificationCronLog;

public interface UserEmailNotificationCronLogRepository extends JpaRepository<UserEmailNotificationCronLog, Long> {
	
	@Query("select u  from UserEmailNotificationCronLog u where u.emailNotificationCode=:notifcode"	+ 
	       " and to_char(u.createdDate,'YYYYMMDD')= to_char(sysdate,'YYYYMMDD') order by u.createdDate desc")
	public List<UserEmailNotificationCronLog> findCronLogEntryForCurrentDate(@Param("notifcode") String notifcode); 

}
